#!/usr/bin/perl -w
#
#	for use with the Dashboard-Widget "Network Stat"
#	(c) by Pascal Pfiffner 2005

my @short = qw(lo0 en0 en1 fw0 ppp0);
my %name = qw(lo0 loopback en0 Ethernet en1 Airport fw0 FireWire ppp0 Dialup);
my $curr = 'lo0';
my $active = 0;
my(%interfaces, %ipv4, %ipv6, %prefixlen, %netmask, %broadcast, %MAC);

open(IFCONFIG, "/sbin/ifconfig|") or die "none?no info|";
while(<IFCONFIG>) {
	/^\w/ ? ($curr = substr($_, 0, index($_, ":"))) : ($interfaces{$curr} .= $_);
}


foreach $key (keys %interfaces) {
	$val = $interfaces{$key};
	
	if(($val =~ /status:\s?active/) || ($key eq 'ppp0')) {		# active interfaces or a dialup connection
		$active++;
		@infos = split(/\s+/, $val);		# split on \s
			
		$ipv4{$key} = 'unknown';
		$ipv6{$key} = 'unknown';
		$prefixlen{$key} = '##';
		$netmask{$key} = 'unknown';
		$broadcast{$key} = 'unknown';
		
		for($i = 0; $i < @infos; $i++) {
			$ipv4{$key} = $infos[$i + 1] if($infos[$i] eq 'inet');			# IPv4
			$ipv6{$key} = $infos[$i + 1] if($infos[$i] eq 'inet6');			# IPv6
			$prefixlen{$key} = $infos[$i + 1] if($infos[$i] eq 'prefixlen');		# Prefix-length
			$netmask{$key} = $infos[$i + 1] if($infos[$i] eq 'netmask');			# Netmask
			$broadcast{$key} = $infos[$i + 1] if($infos[$i] eq 'broadcast');		# Broadcast
			$MAC{$key} = $infos[$i + 1] if($infos[$i] =~  /ether|lladdr/);				# MAC
		}
		
		$ipv6{$key} =~ s/%.+$//;		# remove interface from IPv6
		
		print $name{$key}."?".$ipv4{$key}."?".$ipv6{$key}."?".$prefixlen{$key}."?".$netmask{$key}."?".$broadcast{$key}."?".$MAC{$key}."|";
	}
}

print STDOUT "none?no network?|" unless($active > 0);


